#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_SpecimenTestThreshold : BaseTest 
	{
		private DataTable _dtSpecimentTestThreshold;
		
		private BOL.SpecimenTestThreshold _tstSTT;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				_dtSpecimentTestThreshold = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM SpecimenTestThreshold WHERE ComponentClassId IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				this.RefreshData = false;
			}

			this._tstSTT = new BOL.SpecimenTestThreshold(this._dtSpecimentTestThreshold.Rows[0]);
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.SpecimenTestThreshold tmpSTT = new BOL.SpecimenTestThreshold(this._dtSpecimentTestThreshold.Rows[0]);

			Assert.IsNotNull(tmpSTT);
			Assert.AreEqual(tmpSTT.SpecimenTestThresholdGuid , (System.Guid)this._dtSpecimentTestThreshold.Rows[0][TABLES.SpecimenTestThreshold.SpecimenTestThresholdGuid]);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void SpecimenTestThresholdGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();
				
			this._tstSTT.SpecimenTestThresholdGuid = tstValue;

			Assert.AreEqual(this._tstSTT.SpecimenTestThresholdGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SpecimenTestThresholdGuid_Fail()
		{
		}

		[Test]
		public void ComponentClassId_Pass()
		{
			int tstValue = new Random().Next(99999);

			this._tstSTT.ComponentClassId = tstValue;

			Assert.AreEqual(this._tstSTT.ComponentClassId, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ComponentClassId_Fail()
		{
		}
		
		[Test]
		public void VistaLaboratoryTestName_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstSTT.VistaLaboratoryTestName = tstValue;

			Assert.AreEqual(this._tstSTT.VistaLaboratoryTestName, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void VistaLaboratoryTestName_Fail()
		{
		}
		
		[Test]
		public void SpecimenTypeCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstSTT.SpecimenTypeCode = tstValue;

			Assert.AreEqual(this._tstSTT.SpecimenTypeCode, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SpecimenTypeCode_Fail()
		{
		}
				
		[Test]
		public void LabTestId_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstSTT.LabTestId = tstValue;

			Assert.AreEqual(this._tstSTT.LabTestId, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LabTestId_Fail()
		{
		}
						
		[Test]
		public void WorkloadCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstSTT.WorkloadCode = tstValue;

			Assert.AreEqual(this._tstSTT.WorkloadCode, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void WorkloadCode_Fail()
		{
		}
						
		[Test]
		public void ThresholdResult_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstSTT.ThresholdResult = tstValue;

			Assert.AreEqual(this._tstSTT.ThresholdResult, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ThresholdResult_Fail()
		{
		}
						
		[Test]
		public void ReportTypeId_Pass()
		{
			int tstValue = new Random().Next(99999);

			this._tstSTT.ReportTypeId = tstValue;

			Assert.AreEqual(this._tstSTT.ReportTypeId, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReportTypeId_Fail()
		{
		}
						
		[Test]
		public void DivisionCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstSTT.DivisionCode = tstValue;

			Assert.AreEqual(this._tstSTT.DivisionCode, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DivisionCode_Fail()
		{
		}

						
		[Test]
		public void RecordStatusCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstSTT.RecordStatusCode = tstValue;

			Assert.AreEqual(this._tstSTT.RecordStatusCode, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}
						
		[Test]
		public void RowVersion_Pass()
		{
			byte[] tstValue = new byte[8];

			this._tstSTT.RowVersion = tstValue;

			Assert.AreEqual(this._tstSTT.RowVersion, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RowVersion_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow drTest = this._dtSpecimentTestThreshold.NewRow();

			drTest = this._tstSTT.LoadDataRowFromThis(this._dtSpecimentTestThreshold.NewRow());

			Assert.AreEqual(this._tstSTT.SpecimenTestThresholdGuid, (System.Guid)drTest[TABLES.SpecimenTestThreshold.SpecimenTestThresholdGuid], "SpecimenTestThresholdGuid");
			Assert.AreEqual(this._tstSTT.SpecimenTypeCode, drTest[TABLES.SpecimenTestThreshold.SpecimenTypeCode].ToString(), "SpecimenTypeCode");
			Assert.AreEqual(this._tstSTT.ComponentClassId, (int)drTest[TABLES.SpecimenTestThreshold.ComponentClassId], "ComponentClassId");
			Assert.AreEqual(this._tstSTT.RecordStatusCode, drTest[TABLES.SpecimenTestThreshold.RecordStatusCode].ToString(), "RecordStatusCode");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void GetEmptySpecimentThresholdResultTable_Pass()
		{
			DataTable dtTest = this._tstSTT.GetEmptySpecimentThresholdResultTable();

			Assert.IsTrue(dtTest.Columns.Count == 11);
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptySpecimentThresholdResultTable_Fail()
		{
		}

	}
}

#endif
